/*
 * Decompiled with CFR 0.152.
 */
package com.ssakura49.sdmshopextended.common.shop;

import dev.ftb.mods.ftblibrary.config.ConfigGroup;
import dev.ftb.mods.ftblibrary.config.ConfigValue;
import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftblibrary.icon.ItemIcon;
import dev.ftb.mods.ftbquests.quest.QuestObjectType;
import dev.ftb.mods.ftbquests.quest.ServerQuestFile;
import dev.ftb.mods.ftbquests.quest.loot.RewardTable;
import dev.ftb.mods.ftbquests.quest.loot.WeightedReward;
import dev.ftb.mods.ftbquests.quest.reward.ItemReward;
import dev.ftb.mods.ftbquests.quest.reward.Reward;
import dev.ftb.mods.ftbquests.util.ConfigQuestObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import java.util.function.Predicate;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.sixik.sdmshoprework.SDMShopR;
import net.sixik.sdmshoprework.SDMShopRework;
import net.sixik.sdmshoprework.api.IConstructor;
import net.sixik.sdmshoprework.api.shop.AbstractShopEntry;
import net.sixik.sdmshoprework.api.shop.AbstractShopEntryType;

public class ShopLotteryEntryType
extends AbstractShopEntryType {
    public static final String ID = "sdmshopextended:lottery";
    public RewardTable table;
    public boolean giveCrateInstead = false;

    public ShopLotteryEntryType(RewardTable rewardTable) {
        this.table = rewardTable;
    }

    public void getConfig(ConfigGroup group) {
        ((ConfigQuestObject)group.add("table", (ConfigValue)new ConfigQuestObject((Predicate)QuestObjectType.REWARD_TABLE), (Object)this.table, t -> {
            this.table = t;
        }, (Object)this.table)).setNameKey("sdmshopextended.shop.entry.type.lottery.config.reward_table");
        group.addBool("give_crate", this.giveCrateInstead, v -> {
            this.giveCrateInstead = v;
        }, false).setNameKey("sdmshopextended.shop.entry.type.lottery.config.give_crate");
    }

    public AbstractShopEntryType copy() {
        return new ShopLotteryEntryType(this.table);
    }

    public AbstractShopEntryType.SellType getSellType() {
        return AbstractShopEntryType.SellType.ONLY_BUY;
    }

    public Component getTranslatableForCreativeMenu() {
        return Component.m_237115_((String)"sdmshopextended.shop.entry.type.lottery");
    }

    public List<Component> getDescriptionForContextMenu() {
        ArrayList<Component> list = new ArrayList<Component>();
        list.add((Component)Component.m_237115_((String)"sdmshopextended.shop.entry.type.lottery.description"));
        if (this.table != null) {
            list.add((Component)Component.m_237115_((String)"sdmshopextended.shop.entry.type.lottery.reward_table").m_130946_(": ").m_7220_((Component)this.getTitleOrDefault(this.table, (Component)Component.m_237113_((String)"null")).m_6881_().m_130940_(ChatFormatting.BLUE)));
        }
        return list;
    }

    private Component getTitleOrDefault(RewardTable table, Component def) {
        return table.useTitle ? table.getTitle() : def;
    }

    public void sendNotifiedMessage(Player player) {
        if (this.shopEntry.isSell) {
            player.m_5661_((Component)Component.m_237115_((String)"sdmshopextended.shop.entry.type.lottery.cannot_sell").m_130940_(ChatFormatting.RED), false);
        }
    }

    public String getId() {
        return ID;
    }

    public Icon getIcon() {
        if (this.table != null) {
            Reward r;
            if (this.giveCrateInstead && this.table.lootCrate != null) {
                return ItemIcon.getItemIcon((ItemStack)this.table.lootCrate.createStack());
            }
            List rewards = this.table.rewards;
            if (!rewards.isEmpty() && (r = ((WeightedReward)rewards.get((int)this.playerRandomIndex(rewards))).reward) instanceof ItemReward) {
                ItemReward itemReward = (ItemReward)r;
                return ItemIcon.getItemIcon((ItemStack)itemReward.item);
            }
            return ItemIcon.getItemIcon((ItemStack)new ItemStack((ItemLike)Items.f_42009_));
        }
        return ItemIcon.getItemIcon((ItemStack)new ItemStack((ItemLike)Items.f_42009_));
    }

    private int playerRandomIndex(List<?> list) {
        if (list.isEmpty()) {
            return 0;
        }
        Random rand = new Random();
        return rand.nextInt(list.size());
    }

    public void buy(Player player, int countBuy, AbstractShopEntry entry) {
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer serverPlayer = (ServerPlayer)player;
        if (this.table == null) {
            serverPlayer.m_5661_((Component)Component.m_237115_((String)"sdmshopextended.shop.entry.type.lottery.error.no_table").m_130940_(ChatFormatting.RED), false);
            return;
        }
        long playerMoney = SDMShopR.getMoney((Player)player);
        long needMoney = entry.entryPrice * (long)countBuy;
        boolean success = this.giveCrateInstead ? this.giveCrates(serverPlayer, this.table, countBuy) : this.executeLotteryDraw(serverPlayer, this.table, countBuy);
        if (success) {
            SDMShopR.setMoney((Player)player, (long)(playerMoney - needMoney));
            serverPlayer.m_5661_((Component)Component.m_237115_((String)"sdmshopextended.shop.entry.type.lottery.success").m_130940_(ChatFormatting.GREEN), false);
        } else {
            serverPlayer.m_5661_((Component)Component.m_237115_((String)"sdmshopextended.shop.entry.type.lottery.fail").m_130940_(ChatFormatting.YELLOW), false);
        }
    }

    private boolean executeLotteryDraw(ServerPlayer player, RewardTable table, int totalDraws) {
        if (table == null || totalDraws <= 0) {
            return false;
        }
        try {
            Collection results = table.generateWeightedRandomRewards(player.m_217043_(), totalDraws, false);
            if (results.isEmpty()) {
                return false;
            }
            for (WeightedReward wr : results) {
                wr.reward.claim(player, true);
            }
            return true;
        }
        catch (Exception e) {
            SDMShopRework.LOGGER.error("Failed to execute lottery draw for player " + player.m_7755_().getString(), (Throwable)e);
            return false;
        }
    }

    private boolean giveCrates(ServerPlayer player, RewardTable table, int count) {
        if (table.lootCrate == null) {
            return false;
        }
        ItemStack stack = table.lootCrate.createStack();
        stack.m_41764_(count);
        if (!player.m_150109_().m_36054_(stack)) {
            player.m_36176_(stack, false);
        }
        return true;
    }

    public void sell(Player player, int countSell, AbstractShopEntry entry) {
        player.m_213846_((Component)Component.m_237115_((String)"sdmshopextended.shop.entry.type.lottery.cannot_sell").m_130940_(ChatFormatting.RED));
    }

    public boolean canExecute(Player player, boolean isSell, int countSell, AbstractShopEntry entry) {
        long needMoney;
        if (isSell) {
            return false;
        }
        if (this.table == null) {
            return false;
        }
        long playerMoney = SDMShopR.getMoney((Player)player);
        return playerMoney >= (needMoney = entry.entryPrice * (long)countSell);
    }

    public int howMany(Player player, boolean isSell, AbstractShopEntry entry) {
        if (isSell) {
            return 0;
        }
        if (this.table == null || entry.entryPrice == 0L) {
            return 0;
        }
        long playerMoney = SDMShopR.getMoney((Player)player);
        return (int)(playerMoney / entry.entryPrice);
    }

    public CompoundTag serializeNBT() {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128359_("shopEntryTypeID", ID);
        if (this.table != null) {
            nbt.m_128356_("table_id", this.table.id);
        }
        nbt.m_128379_("give_crate", this.giveCrateInstead);
        return nbt;
    }

    public void deserializeNBT(CompoundTag nbt) {
        long id;
        nbt.m_128461_(ID);
        this.table = nbt.m_128441_("table_id") ? ((id = nbt.m_128454_("table_id")) != -1L ? ServerQuestFile.INSTANCE.getRewardTable(id) : null) : null;
        this.giveCrateInstead = nbt.m_128471_("give_crate");
    }

    public static class Constructor
    implements IConstructor<AbstractShopEntryType> {
        public ShopLotteryEntryType createDefaultInstance() {
            return new ShopLotteryEntryType(null);
        }
    }
}

